<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\UserToken
 *
 * @ORM\Table(name="user_tokens")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\UserTokenRepository")
 *
 * @ExclusionPolicy("all")
 */
class UserToken
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $id;


    /**
     * @var integer $token_list_id
     *
     * @ORM\Column(name="token_list_id", type="integer")
     */
    protected $token_list_id;


    /**
     * @var string $token
     *
     * @ORM\Column(name="token", type="integer", length=6)
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $token;


    /**
     * @var string $sequence
     *
     * @ORM\Column(name="sequence", type="integer", length=6)
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $sequence;

    /**
     * @var string $used
     *
     * @ORM\Column(name="used", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $used = false;

    /**
     * @var integer
     *
     * @ORM\Column(name="confirmInfo_id", type="integer", nullable=true)
     */
    private $confirmInfoId;

    /**
     * @ORM\OneToOne(targetEntity="UserTokenConfirmInfo", inversedBy="userToken", cascade={"all"})
     * @ORM\JoinColumn(name="confirmInfo_id", referencedColumnName="id")
     */
    protected $confirmInfo;

    /**
     * @var integer
     *
     * @ORM\Column(name="creator_stages_company_confirm_id", type="integer", nullable=true)
     *
     */
    private $creatorStagesCompanyConfirmId;

    /**
     * @ORM\ManyToOne(targetEntity="CreatorStagesCompanyConfirm",inversedBy="tokens")
     * @ORM\JoinColumn(name="creator_stages_company_confirm_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"partsList"})
     */
    private $creatorStagesCompanyConfirm;


    /**
     * @ORM\ManyToOne(targetEntity="UserTokenList", inversedBy="tokens")
     * @ORM\JoinColumn(name="token_list_id", referencedColumnName="id")
     */
    protected $tokenList;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set token
     *
     * @param string $token
     * @return UserToken
     */
    public function setToken($token)
    {
        $this->token = $token;
    
        return $this;
    }

    /**
     * Get token
     *
     * @return string 
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * Set used
     *
     * @param boolean $used
     * @return UserToken
     */
    public function setUsed($used)
    {
        $this->used = $used;
    
        return $this;
    }

    /**
     * Get used
     *
     * @return boolean 
     */
    public function getUsed()
    {
        return $this->used;
    }

    /**
     * Set creatorStagesCompanyConfirmId
     *
     * @param integer $creatorStagesCompanyConfirmId
     * @return UserToken
     */
    public function setCreatorStagesCompanyConfirmId($creatorStagesCompanyConfirmId)
    {
        $this->creatorStagesCompanyConfirmId = $creatorStagesCompanyConfirmId;
    
        return $this;
    }

    /**
     * Get creatorStagesCompanyConfirmId
     *
     * @return integer 
     */
    public function getCreatorStagesCompanyConfirmId()
    {
        return $this->creatorStagesCompanyConfirmId;
    }

    /**
     * Set creatorStagesCompanyConfirm
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirm
     * @return UserToken
     */
    public function setCreatorStagesCompanyConfirm(\VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirm = null)
    {
        $this->creatorStagesCompanyConfirm = $creatorStagesCompanyConfirm;
    
        return $this;
    }

    /**
     * Get creatorStagesCompanyConfirm
     *
     * @return \VM\ApiBundle\Entity\CreatorStagesCompanyConfirm 
     */
    public function getCreatorStagesCompanyConfirm()
    {
        return $this->creatorStagesCompanyConfirm;
    }

    /**
     * Set token_list_id
     *
     * @param integer $tokenListId
     * @return UserToken
     */
    public function setTokenListId($tokenListId)
    {
        $this->token_list_id = $tokenListId;
    
        return $this;
    }

    /**
     * Get token_list_id
     *
     * @return integer 
     */
    public function getTokenListId()
    {
        return $this->token_list_id;
    }

    /**
     * Set tokenList
     *
     * @param \VM\ApiBundle\Entity\UserTokenList $tokenList
     * @return UserToken
     */
    public function setTokenList(\VM\ApiBundle\Entity\UserTokenList $tokenList = null)
    {
        $this->tokenList = $tokenList;
    
        return $this;
    }

    /**
     * Get tokenList
     *
     * @return \VM\ApiBundle\Entity\UserTokenList 
     */
    public function getTokenList()
    {
        return $this->tokenList;
    }

    /**
     * Set sequence
     *
     * @param integer $sequence
     * @return UserToken
     */
    public function setSequence($sequence)
    {
        $this->sequence = $sequence;
    
        return $this;
    }

    /**
     * Get sequence
     *
     * @return integer 
     */
    public function getSequence()
    {
        return $this->sequence;
    }

    /**
     * Set confirmInfo
     *
     * @param \VM\ApiBundle\Entity\UserTokenConfirmInfo $confirmInfo
     * @return UserToken
     */
    public function setConfirmInfo(\VM\ApiBundle\Entity\UserTokenConfirmInfo $confirmInfo = null)
    {
        $this->confirmInfo = $confirmInfo;
    
        return $this;
    }

    /**
     * Get confirmInfo
     *
     * @return \VM\ApiBundle\Entity\UserTokenConfirmInfo 
     */
    public function getConfirmInfo()
    {
        return $this->confirmInfo;
    }

    /**
     * Set confirmInfoId
     *
     * @param integer $confirmInfoId
     * @return UserToken
     */
    public function setConfirmInfoId($confirmInfoId)
    {
        $this->confirmInfoId = $confirmInfoId;
    
        return $this;
    }

    /**
     * Get confirmInfoId
     *
     * @return integer 
     */
    public function getConfirmInfoId()
    {
        return $this->confirmInfoId;
    }
}